# -*- coding: utf-8 -*-

from django.shortcuts import render_to_response
from django.http import HttpResponseRedirect
from datetime import datetime
from forms import LoginForm, StudentProfileForm, EmployeeProfileForm

def welcome(request):
  return render_to_response('welcome.html', {'current_date_time': datetime.now})

def login(request):
  # Test si formulaire a été envoyé
  if len(request.GET) > 0:
    form = LoginForm(request.GET)
    if form.is_valid():
      return HttpResponseRedirect('/welcome')
    else:
      return render_to_response ('login.html', {'form': form})
  # Le formulaire n'a pas été envoyé
  else:
    form = LoginForm()
    return render_to_response ('login.html', {'form': form})
  
def register(request):
  if len(request.GET) > 0:
    form = StudentProfileForm(request.GET)
    if form.is_valid():
      form.save(commit=True)
      return HttpResponseRedirect('/login')
    else:
      return render_to_response ('login.html', {'form': form})
  else:
    form = StudentProfileForm()
    return render_to_response ('user_profile.html', {'form': form})


def register2(request):
  if len(request.GET) > 0 and 'profileType' in request.GET:
    studentForm = StudentProfileForm(prefix="st")
    employeeForm = EmployeeProfileForm(prefix="em")
    if request.GET['profileType'] == 'student':
      studentForm = StudentProfileForm(request.GET, prefix="st")
      if studentForm.is_valid():
        studentForm.save(commit=True)
        return HttpResponseRedirect('/login')
    elif request.GET['profileType'] == 'employee':
      employeeForm = EmployeeProfileForm(request.GET, prefix="em")
      if employeeForm.is_valid():
        employeeForm.save(commit=True)
        return HttpResponseRedirect('/login')
    # Le formulaire envoyé n'est pas valide
    return render_to_response('user_profile2.html', 
                               {'studentForm': studentForm, 
                                'employeeForm': employeeForm})
  else: 
    studentForm = StudentProfileForm(prefix="st")
    employeeForm = EmployeeProfileForm(prefix="em")
    return render_to_response('user_profile2.html', 
                               {'studentForm': studentForm, 
                                'employeeForm': employeeForm})